function [totalAirTime,totalDataFlow,avgSubscriberPerYear] = market(userPerSat,Nmin,Afoot,IDTime,spaceLife,Ruser);
% market.m
% Program that calculates the number of users captured by the system
% Darren Chang (darrenz@mit.edu)
% Last modified by 9/8/02

% *********************************************************************************
% If the datarate is below 50 kbps, then it is considered
% as a low bandwidth system. Its marketing is modeled
% using the data for low-bandwidth satellites.

if Ruser < 50
    % Assume the initial development starts in 2004
    % (The globalPotentialUser in the first year of the spacelife of the system)
    % = (globalPotentialUser in 2003) + (increment per year)*(Initial Development Time + 1)
    % The data are based on Globalstar.
    % Population is in unit of million.
    % 49.60 is the potential user number in 2003.
    % The annual increment is 2.9677.
    globalPotentialUser1stYear = 49.60 + 2.9677*(IDTime + 1);

    % Now calculate the total number of users
    % during the spacelife of the system.
    globalPotentialUserLastYear = globalPotentialUser1stYear + 2.9677*(spaceLife - 1);
    totalPotentialUser = (globalPotentialUser1stYear + globalPotentialUserLastYear)*spaceLife/2; %[million]
else
    % *********************************************************************************
    % If the datarate is above 50 kbps, then it is considered
    % as a high bandwidth system. Then its marketing is modeled
    % using the data for high-bandwidth satellites.

    % Same assumption and unit as the low-bandwidth case
    % 4.9158 is the potential user number in 2003.
    globalPotentialUser1stYear = 4.9158 + 0.5159*(IDTime + 1);

    % Now calculate the total number of users
    % during the spacelife of the system.
    globalPotentialUserLastYear = globalPotentialUser1stYear + 0.5159*(spaceLife - 1);
    totalPotentialUser = (globalPotentialUser1stYear + globalPotentialUserLastYear)*spaceLife/2; %[million]
end;

% *********************************************************************************
% To find the total number of subscribers over the spacelife
% of the system, we pick the smaller of the number of potential
% users and the number of capacity-supportable users.
earthLandArea = 148326000;  % [km^2]
earthSurfaceArea = 4*pi*6371^2; % [km^2]
potentialUserPerKm2 = totalPotentialUser*1e6/earthLandArea; %[person/km^2]
capacityPerKm2 = userPerSat*spaceLife/(earthSurfaceArea/Nmin);
subscriberPerKm2 = min(potentialUserPerKm2,capacityPerKm2);
totalSubscriber = subscriberPerKm2*earthLandArea;    %[person]

% *********************************************************************************
% Assume that each user makes use of the satellite connection
% for one hour everyday.  There are 365 days in a year.
totalAirTime = totalSubscriber*365*24*60;  %[min]
totalDataFlow = totalAirTime*60*Ruser*1e3/1e6;    %[MB]
avgSubscriberPerYear = totalSubscriber/spaceLife; %[person]


